/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8224;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.ContextSwitcher;
import ibm.nways.jdm.modelgen.InstrumentationContext;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.modelgen.SnmpInstrContext;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public final class HubContextSwitcher
implements ContextSwitcher {
    private static final int RASID = 4;
    private static final int RASSUB = 1;

    public final InstrumentationContext createNewContext(InstrumentationContext instrumentationContext, LocalModel localModel, Serializable[] serializableArray) {
        ModelInfo modelInfo;
        String string = null;
        if (RAS.isEnabled(4, 1)) {
            RAS.enter(4, 1, this, "createNewContext");
        }
        if (serializableArray[0] instanceof SpecialValue) {
            if (RAS.isEnabled(4, 1)) {
                RAS.trace(4, 1, this, "createNewContext", "indexes[0] timeout");
            }
            return instrumentationContext;
        }
        String string2 = ((Integer)serializableArray[0]).toString();
        int n = (Integer)serializableArray[0];
        if (RAS.isEnabled(4, 1)) {
            RAS.trace(4, 1, this, "createNewContext", "Indexes[0] is " + string2);
        }
        ModelInfo modelInfo2 = new ModelInfo();
        modelInfo2.add("Index.StackIndex", new Integer(n));
        try {
            modelInfo = localModel.getInfo("Panel", "default", modelInfo2);
            if (modelInfo == null) {
                if (RAS.isEnabled(4, 1)) {
                    RAS.trace(4, 1, this, "createNewContext", "Cannot get Panel information. ModelInfo null");
                }
                return instrumentationContext;
            }
            Serializable serializable = modelInfo.get("Panel.IpAddr");
            string = serializable.toString();
            if (RAS.isEnabled(4, 1)) {
                RAS.trace(4, 1, this, "createNewContext", "ipAddress is" + string);
            }
        }
        catch (Exception exception) {
            RAS.logException(4, 1, this, " createNewContext", exception);
        }
        modelInfo = ((SnmpInstrContext)instrumentationContext).getSession();
        if (RAS.isEnabled(4, 1)) {
            RAS.trace(4, 1, this, "createNewContext", "ipAddress:" + string);
        }
        if (string != null) {
            try {
                if (RAS.isEnabled(4, 1)) {
                    RAS.exit(4, 1, this, "createNewContext");
                }
                return new SnmpInstrContext(string, (SnmpSession)modelInfo);
            }
            catch (Exception exception) {
                if (RAS.isEnabled(4, 1)) {
                    RAS.exit(4, 1, this, "createNewContext");
                }
                RAS.logException(4, 1, this, " createNewContext", exception);
            }
        }
        return instrumentationContext;
    }
}

